// Pixelated shader by daxnitro, because Minecraft wasn't low-res enough.

uniform sampler2D sampler0;

uniform float aspectRatio;

vec4 getBoxColor(vec2 coord, vec2 boxSize, vec2 sampleInterval);

void main() {
    vec4 color = getBoxColor(gl_TexCoord[0].st, vec2(0.01, 0.01 * aspectRatio), vec2(0.002, 0.002 * aspectRatio));
    
	gl_FragColor = color;
}

vec4 getBoxColor(vec2 coord, vec2 boxSize, vec2 sampleInterval) {
	vec2 limit = min(coord + boxSize, 1.0);
	
	coord -= mod(coord, boxSize);
	
	vec4 color = vec4(0.0);
	
	float samples = 0.0;
	
	do {
		color += texture2D(sampler0, coord);
		++samples;
		coord += sampleInterval;
	} while (coord.x < limit.x && coord.y < limit.y);
	
	color /= samples;
	
	return color;
}
